#declare sunshine=1.3;
#declare sunset=0;
#declare dawn=0;  
#declare night=0;
#declare infinite_sky=1;
#declare clouds=0; // 0 or 1
#declare fog_transparency=0.6; // 0; //0.80; // ,70
#declare fog_distance=70; 

#declare ht=10; // 1.2 2.5;
#declare ds=10;
#declare geodesic_shell=1; // 0 or 1
#declare geodesic_core=0; // 0 or 1 

#declare focal=0.0; // .1 .4 1.5




#include "colors.inc"
#include "functions.inc"

  camera{
    location <0, 0, -15> look_at < 0, ht, ds >
    angle 35 //zoom 16 norm 30 wide angle 60
    #if (focal>0) 
     focal_point <0, 0, ds>   
     aperture  focal // 0.4     // a nice compromise
     //  blur_samples 4       // fewer samples, faster to render
     blur_samples 20      // more samples, higher quality image
    #end
  } 




#if (sunset>0)
 #declare cloud_light=0.15;
 light_source{ <500,100,-500> color rgb sunshine*1.2*<1,0.7,0.4> }  // sunset
#else
 #if (dawn>0)  
  #declare cloud_light=0.35;
  light_source{ <3000,3000,3000> color rgb sunshine*2*<1,1,1> }     // bright
  light_source{ <500,500,-500> color rgb sunshine*.5*<0.35,0.0,0.5> }     // bright
 #end
 #if (night>0)  
  #declare cloud_light=0.35;
  light_source{ <3000,3000,3000> color rgb sunshine*.75*<1,1,1> }     // bright
  light_source{ <500,500,-500> color rgb sunshine*.25*<0.35,0.0,0.5> }     // bright
 #end
 #if (night+dawn=0)
  #declare cloud_light=0.35;
  light_source{ <500,500,-500> color rgb sunshine*<1,1,1> }     // bright
 #end
#end


#declare buckminster_fuller=
box { <0,0,0>,<1,1,0.001>
 texture { 
  pigment {
   image_map {jpeg "fuller2.jpg"}
   }
   finish { ambient 0.7 }
  } // texture
  translate <-0.5,-0.5,0.0>
  scale <2,2,1>
  translate <0,ht+2,ds-2>
 }

#if (geodesic_shell>0)
 union {
  #include "geo.inc"
  scale 5  rotate 0*y translate < 0,ht,ds>  finish { ambient 0.7 } 
 }
#end


#if (geodesic_core>0)
// decks
union {
difference {
union {
//cylinder { <0,-.05,0>,<0,0,0>,0.55 scale 5 translate <0,4,0> }
cylinder { <0,-.05,0>,<0,0,0>,0.85 scale 5 translate <0,2,0> }
cylinder { <0,-.05,0>,<0,0,0>,0.95 scale 5 translate <0,0,0> }
cylinder { <0,-.05,0>,<0,0,0>,0.85 scale 5 translate <0,-2,0> }
}
cylinder { <0,-.8,0>,<0,0.8,0>,0.25 scale 5 translate <0,0,0> }
} 
difference {
cylinder { <0,-.95,0>,<0,0.95,0>,0.25 scale 5 translate <0,0,0> }
cylinder { <0,-.81,0>,<0,0.81,0>,0.23 scale 5 translate <0,0,0> }
cylinder { <0,-.81,-.23>,<0,0.81,-.23>,0.07 scale 5 translate <0,0,0> }
cylinder { <0,-.81,.23>,<0,0.81,.23>,0.07 scale 5 translate <0,0,0> }
cylinder { <.23,-.81,0>,<.23,0.81,0>,0.07 scale 5 translate <0,0,0> }
cylinder { <-.23,-.81,0>,<-.23,0.81,0>,0.07 scale 5 translate <0,0,0> }
}  
translate <0,ht,ds>
texture { pigment { color rgb <0.6,0.5,0.5> }}
//normal { bumps 0.01 }
finish { ambient 0.9 }
}

// deck objects
union {
cone     { <0,0,0>,.5,<0,1,0>,0.1 scale 1 translate <2,ht+2,ds> }
cylinder { <0,0,0>,<0,1,0>,.5 scale 1 translate <2,ht,ds> }
cylinder { <0,0,0>,<0,1,0>,.5 scale 1 translate <2,ht-2,ds> }
texture { pigment { color rgbt <0.8,0.4,0.2,0> }}
//normal { bumps 0.01 }
finish { ambient 0.5}
}
#end

#if (infinite_sky>0)   
sky_sphere {
  pigment {
  gradient y
  color_map {
  [ 0,0.25  color rgb < 0.0, 1.0, 1.0 > 
         color rgb < 0.0, 0.0, 0.5 > ]
  }
  scale 2
  translate y*-0.01
  }
 }
#end


// several layers of cloud
#if (clouds>0) 
 #include "clouds.inc"
#end 


 
// for murky conditions

  fog {
    fog_type 2
    fog_offset 0
    fog_alt 20
    turbulence 0.9
    turb_depth 0.1
    color rgbt<0.8, 0.8, 0.8, fog_transparency >
    distance fog_distance
   }


 


